import 'package:flutter/material.dart';

void showCustomTopSheetWidget(
    BuildContext context, {required Widget widget}) {
  showGeneralDialog(
    context: context,
    barrierDismissible: true,
    transitionDuration: const Duration(milliseconds: 500),
    barrierLabel: MaterialLocalizations.of(context).dialogLabel,
    barrierColor: Colors.black.withValues(alpha:0.5),
    pageBuilder: (context, _, __) {
      return widget;
    },
    transitionBuilder: (context, animation, secondaryAnimation, child) {
      return SlideTransition(position: CurvedAnimation(parent: animation,
          curve: Curves.easeOut).drive(Tween<Offset>(
          begin: const Offset(0, -1.0), end: Offset.zero)), child: child);
    },
  );
}
